% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_features_QSAR.R
\name{extract_features_QSAR}
\alias{extract_features_QSAR}
\title{Extract QSAR Features from Peptide Sequences}
\usage{
extract_features_QSAR(
  n,
  pH = 7.4,
  custom.list = FALSE,
  PeList = NULL,
  rem.cys = FALSE,
  rem.met = FALSE,
  rem.sali = FALSE,
  norm = FALSE
)
}
\arguments{
\item{n}{The length of the peptide sequences.Must be more than 2.}

\item{pH}{The pH used for calculating charge (default is 7.4).}

\item{custom.list}{A boolean indicating if a custom peptide list is provided (default is FALSE).}

\item{PeList}{The custom list of peptides (required if custom.list is TRUE).}

\item{rem.cys}{A boolean indicating if sequences with Cys should be removed (default is FALSE).}

\item{rem.met}{A boolean indicating if sequences with Met should be removed (default is FALSE).}

\item{rem.sali}{A boolean indicating if sequences with 2 or more small aliphatic amino acids should be removed (default is FALSE).}

\item{norm}{A boolean indicating if the data should be normalized (default is FALSE).}
}
\value{
A dataframe with the calculated peptide properties.
}
\description{
This function extracts various Quantitative Structure-Activity Relationship (QSAR) features
from peptide sequences. The extraction is based on a variety of amino acid properties
and functions from the "Peptides" package (https://github.com/dosorio/Peptides/).
}
\examples{
extract_features_QSAR(n = 3, custom.list = TRUE, PeList = c('ACA', 'ADE'))
}
