% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_subgroup_two_part.R
\name{fit_subgroup_2part}
\alias{fit_subgroup_2part}
\title{Fitting subgroup identification models for semicontinuous positive outcomes}
\usage{
fit_subgroup_2part(
  x,
  y,
  trt,
  propensity.func = NULL,
  propensity.func.positive = NULL,
  match.id = NULL,
  augment.func.zero = NULL,
  augment.func.positive = NULL,
  cutpoint = 1,
  larger.outcome.better = TRUE,
  penalize.ate = TRUE,
  y_eps = 1e-06,
  ...
)
}
\arguments{
\item{x}{The design matrix (not including intercept term)}

\item{y}{The nonnegative response vector}

\item{trt}{treatment vector with each element equal to a 0 or a 1, with 1 indicating
treatment status is active.}

\item{propensity.func}{function that inputs the design matrix x and the treatment vector trt and outputs
the propensity score, ie Pr(trt = 1 | X = x). Function should take two arguments 1) x and 2) trt. See example below.
For a randomized controlled trial this can simply be a function that returns a constant equal to the proportion
of patients assigned to the treatment group, i.e.:
\code{propensity.func = function(x, trt) 0.5}.}

\item{propensity.func.positive}{function that inputs the design matrix x and the treatment vector trt and outputs
the propensity score for units with positive outcome values, ie Pr(trt = 1 | X = x, Z = 1). Function should take
two arguments 1) x and 2) trt. See example below.
For a randomized controlled trial this can simply be a function that returns a constant equal to the proportion
of patients assigned to the treatment group, i.e.:
\code{propensity.func = function(x, trt) 0.5}.}

\item{match.id}{a (character, factor, or integer) vector with length equal to the number of observations in \code{x}
indicating using integers or levels of a factor vector which patients are
in which matched groups. Defaults to \code{NULL} and assumes the samples are not from a matched cohort. Matched
case-control groups can be created using any method (propensity score matching, optimal matching, etc). If each case
is matched with a control or multiple controls, this would indicate which case-control pairs or groups go together.
If \code{match.id} is supplied, then it is unecessary to specify a function via the \code{propensity.func} argument.
A quick usage example: if the first patient is a case and the second and third are controls matched to it, and the
fouth patient is a case and the fifth through seventh patients are matched with it, then the user should specify
\code{match.id = c(1,1,1,2,2,2,2)} or \code{match.id = c(rep("Grp1", 3),rep("Grp2", 4)) }
the covariates \code{x}, and \code{trt} and outputs predicted values (on the probability scale) for the response using a model
constructed with \code{x}. \code{augment.func.zero()} can also be simply
a function of \code{x} and \code{y}. This function is used for efficiency augmentation.
When the form of the augmentation function is correct, it can provide efficient estimation of the subgroups. Some examples of possible
augmentation functions are:

Example 1: \code{augment.func <- function(x, y) {lmod <- glm(y ~ x, family = binomial()); return(fitted(lmod))}}

Example 2:
\preformatted{
augment.func <- function(x, y, trt) {
    data <- data.frame(x, y, trt)
    lmod <- glm(y ~ x * trt, family = binomial())
    ## get predictions when trt = 1
    data$trt <- 1
    preds_1  <- predict(lmod, data, type = "response")

    ## get predictions when trt = -1
    data$trt <- -1
    preds_n1 <- predict(lmod, data, type = "response")

    ## return predictions averaged over trt
    return(0.5 * (preds_1 + preds_n1))
}
}}

\item{augment.func.zero}{(similar to augment.func.positive) function which inputs the
indicators of whether each response is positive (\code{1*(y > 0)}),
the covariates \code{x}, and \code{trt} for all samples and outputs predicted values (on the link scale) for the response using a model
constructed with \code{x}. \code{augment.func.positive()} can also be simply
a function of \code{x} and \code{y}. This function is used for efficiency augmentation.}

\item{augment.func.positive}{(similar to augment.func.zero) function which inputs the positive part response
(ie all observations in \code{y} which are strictly positive),
the covariates \code{x}, and \code{trt} and outputs predicted values (on the link scale) for the response using a model
constructed with \code{x}. \code{augment.func.positive()} can also be simply
a function of \code{x} and \code{y}. This function is used for efficiency augmentation.}

\item{cutpoint}{numeric value for patients with benefit scores above which
(or below which if \code{larger.outcome.better = FALSE})
will be recommended to be in the treatment group. Defaults to 1, since the benefit score is a risk ratio}

\item{larger.outcome.better}{boolean value of whether a larger outcome is better/preferable. Set to \code{TRUE}
if a larger outcome is better/preferable and set to \code{FALSE} if a smaller outcome is better/preferable. Defaults to \code{TRUE}.}

\item{penalize.ate}{should the treatment main effect (ATE) be penalized too?}

\item{y_eps}{positive value above which observations in \code{y} will be considered positive}

\item{...}{options to be passed to \code{\link[personalized2part]{cv.hd2part}}}
}
\description{
Fits subgroup identification models
}
\examples{

set.seed(42)

dat <- sim_semicontinuous_data(250, n.vars = 15)
x <- dat$x
y <- dat$y
trt <- dat$trt

prop_func <- function(x, trt)
{
    propensmod <- glm(trt ~ x, family = binomial())

    propens <- unname(fitted(propensmod))
    propens
}

fitted_model <- fit_subgroup_2part(x, y, trt, prop_func, prop_func)

fitted_model

## correlation of estimated covariate-conditional risk ratio and truth
cor(fitted_model$benefit.scores, dat$treatment_risk_ratio, method = "spearman")


}
