% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_two_part.R
\name{hdgamma}
\alias{hdgamma}
\title{Fitting function for lasso penalized GLMs}
\usage{
hdgamma(
  x,
  y,
  weights = rep(1, NROW(x)),
  offset = NULL,
  penalty_factor = NULL,
  nlambda = 100L,
  lambda_min_ratio = ifelse(n < p, 0.05, 0.005),
  lambda = NULL,
  tau = 0,
  intercept = TRUE,
  strongrule = TRUE,
  maxit_irls = 50,
  tol_irls = 1e-05,
  maxit_mm = 500,
  tol_mm = 1e-05
)
}
\arguments{
\item{x}{an n x p matrix of covariates for the zero part data, where each row is an observation
and each column is a predictor}

\item{y}{a length n vector of responses taking strictly positive values.}

\item{weights}{a length n vector of observation weights}

\item{offset}{a length n vector of offset terms}

\item{penalty_factor}{a length p vector of penalty adjustment factors corresponding to each covariate.
A value of 0 in the jth location indicates no penalization on the jth variable, and any positive value will
indicate a multiplicative factor on top of the common penalization amount. The default value is 1 for
all variables}

\item{nlambda}{the number of lambda values. The default is 100.}

\item{lambda_min_ratio}{Smallest value for \code{lambda}, as a fraction of lambda.max, the data-derived largest lambda value
The default depends on the sample size relative to the number of variables.}

\item{lambda}{a user supplied sequence of penalization tuning parameters. By default, the program automatically
chooses a sequence of lambda values based on \code{nlambda} and \code{lambda_min_ratio}}

\item{tau}{a scalar numeric value between 0 and 1 (included) which is a mixing parameter for sparse group lasso penalty.
0 indicates group lasso and 1 indicates lasso, values in between reflect different emphasis on group and lasso penalties}

\item{intercept}{whether or not to include an intercept. Default is \code{TRUE}.}

\item{strongrule}{should a strong rule be used?}

\item{maxit_irls}{maximum number of IRLS iterations}

\item{tol_irls}{convergence tolerance for IRLS iterations}

\item{maxit_mm}{maximum number of MM iterations. Note that for \code{algorithm = "irls"}, MM is used within
each IRLS iteration, so \code{maxit_mm} applies to the convergence of the inner iterations in this case.}

\item{tol_mm}{convergence tolerance for MM iterations. Note that for \code{algorithm = "irls"}, MM is used within
each IRLS iteration, so \code{tol_mm} applies to the convergence of the inner iterations in this case.}
}
\description{
This function fits penalized gamma GLMs
}
\examples{

library(personalized2part)

}
