% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_hd2part.R
\name{plot.hd2part}
\alias{plot.hd2part}
\alias{plot.cv.hd2part}
\title{Plot method for hd2part fitted objects}
\usage{
\method{plot}{hd2part}(
  x,
  model = c("zero", "positive"),
  xvar = c("loglambda", "norm", "lambda"),
  labsize = 0.6,
  xlab = iname,
  ylab = NULL,
  main = paste(model, "model"),
  ...
)

\method{plot}{cv.hd2part}(x, sign.lambda = 1, ...)
}
\arguments{
\item{x}{fitted "hd2part" model object}

\item{model}{either \code{"zero"} for the zero part model or \code{"positive"} for the positive part model}

\item{xvar}{What is on the X-axis. \code{"norm"} plots against the L1-norm of the coefficients, \code{"lambda"} against the log-lambda sequence, and \code{"dev"}
against the percent deviance explained.}

\item{labsize}{size of labels for variable names. If labsize = 0, then no variable names will be plotted}

\item{xlab}{label for x-axis}

\item{ylab}{label for y-axis}

\item{main}{main title for plot}

\item{...}{other graphical parameters for the plot}

\item{sign.lambda}{Either plot against log(lambda) (default) or its negative if \code{sign.lambda = -1}.}
}
\description{
Plot method for hd2part fitted objects
}
\examples{
set.seed(123)

set.seed(123)

}
