% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_two_part.R
\name{predict.cv.hd2part}
\alias{predict.cv.hd2part}
\title{Prediction function for fitted cross validation hd2part objects}
\usage{
\method{predict}{cv.hd2part}(
  object,
  newx,
  model = c("zero", "positive"),
  s = c("lambda.min", "lambda.1se"),
  type = c("link", "model_response", "response", "coefficients", "nonzero"),
  ...
)
}
\arguments{
\item{object}{fitted \code{"cv.hd2part"} model object}

\item{newx}{Matrix of new values for \code{x} at which predictions are to be made. Must be a matrix; can be sparse as in the
\code{CsparseMatrix} objects of the \pkg{Matrix} package
This argument is not used for \code{type = c("coefficients","nonzero")}}

\item{model}{either \code{"zero"} for the zero part model or \code{"positive"} for the positive part model}

\item{s}{Value(s) of the penalty parameter lambda at which predictions are required. Default is the entire sequence used to create
the model. For \code{predict.cv.hd2part()}, can also specify \code{"lambda.1se"} or \code{"lambda.min"} for best lambdas estimated
by cross validation.}

\item{type}{Type of prediction required. \code{type = "link"} gives the linear predictors;
\code{type = "model_response"} gives the fitted probabilities for the zero part and fitted expected values for the positive part.
\code{type = "response"} gives the combined response prediction across the two models using the full unconditional expected
value of the response. When \code{type = "response"}, argument \code{"model"} is unused.
\code{type = "coefficients"} computes the coefficients at the requested values for \code{s}.}

\item{...}{arguments to be passed to \code{\link[personalized2part]{predict.hd2part}}}
}
\description{
Prediction function for fitted cross validation hd2part objects
}
\examples{
set.seed(123)

}
