% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sourdoughRecipeTimes.R
\name{adjust_sourdough_time}
\alias{adjust_sourdough_time}
\title{Adjust Sourdough Recipe Fermentation and Proofing Times Based on Temperature}
\usage{
adjust_sourdough_time(
  original_time,
  recipe_temp,
  actual_temp,
  q10 = 2,
  temp_unit = c("F", "C")
)
}
\arguments{
\item{original_time}{The original time(s) specified in the original recipe.}

\item{recipe_temp}{The intended ambient temperature in the original recipe.}

\item{actual_temp}{The actual ambient temperature used.}

\item{q10}{The \eqn{Q_{10}} temperature coefficient (describes rate change
per 10°C).}

\item{temp_unit}{"F" for Fahrenheit; "C" for Celsius.}
}
\value{
The adjusted sourdough fermentation or proofing time(s).
}
\description{
Adjust sourdough recipe fermentation and proofing times based on temperature.
}
\details{
Adjusts sourdough recipe fermentation and proofing times based on ambient
temperature. Suggested times are calculated using the \eqn{Q_{10}}
temperature coefficient, which describes how the rate of fermentation changes
with a 10°C temperature difference.
}
\examples{
adjust_sourdough_time(
  original_time = c(12, 15, 18),
  recipe_temp = 70,
  actual_temp = 75
  )

}
\seealso{
\url{https://en.wikipedia.org/wiki/Q10_(temperature_coefficient)}
}
\concept{baking}
