% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_fun.R
\name{prior}
\alias{prior}
\title{Beta priors determination based on different prior information}
\usage{
prior(type, mu, v, N, W, init)
}
\arguments{
\item{type}{type of prior information: "MeanVar" uses mean and variance, "Optimist" uses (ORR) mean, "ORRN" uses ORR and smaple size, "ORRW" uses ORR and CI width.}

\item{mu}{prior(ORR) mean.}

\item{v}{prior variance}

\item{N}{prior sample size.}

\item{W}{prior confidence interval width.}

\item{init}{initial value to solve the nonlinear equations for "ORRW" type.}
}
\value{
\item{parameters}{the vector of Beta parameters: \eqn{a} and \eqn{b}}
}
\description{
The prior function to calculate the Beta prior parameters
}
\examples{
prior(type = "MeanVar", mu=0.2, v=0.025)
prior(type = "Optimist", mu = 0.2)
prior(type = "ORRN", mu = 0.2, N = 10)
prior(type = "ORRW", mu = 0.2, W = 0.5)
}
\references{
Thall, P. F., Simon, R. (1994).
Practical Bayesian guidelines for phase IIB clinical trials.
\emph{Biometrics} \strong{50}: 337-349.

Mayo, M. S., & Gajewski, B. J. (2004).
Bayesian sample size calculations in phase II clinical trials using informative conjugate priors.
\emph{Controlled clinical trials} \strong{25}(2): 157-167.

Tan, S. B., & Machin, D. (2002).
Bayesian two-stage designs for phase II clinical trials.
\emph{Statistics in medicine} \strong{21}(14): 1991-2012.
New York: Wiley.
}

