% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand_phenocam.r
\name{expand_phenocam}
\alias{expand_phenocam}
\title{Expand a PhenoCam time series from 3-day to a 1-day time step}
\usage{
expand_phenocam(data, truncate = NULL, internal = TRUE, out_dir = tempdir())
}
\arguments{
\item{data}{a PhenoCam file}

\item{truncate}{year (numerical), limit the time series
to a particular year (default = NULL)}

\item{internal}{return a data structure if given a file on disk
(\code{TRUE} / \code{FALSE} = default)}

\item{out_dir}{output directory where to store data (default = tempdir())}
}
\value{
Expanded PhenoCam data structure or file, including 90 day padding
if requested.
}
\description{
Necessary step to guarantee consistent data processing between 1 and 3-day
data products. Should rarely be used independent of `download_phenocam()`.
}
\examples{

\dontrun{
# download demo data
download_phenocam(site = "harvard$",
                  veg_type = "DB",
                  roi_id = "1000",
                  frequency = "3")

# Overwrites the original file, increasing
# it's file size.
expand_phenocam(file.path(tempdir(),"harvard_DB_1000_3day.csv"))

# Contracts the file to it's original size, skipping
# two days.
contract_phenocam(file.path(tempdir(),"harvard_DB_1000_3day.csv"))
}
}
