% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lamp-types.r
\docType{data}
\name{lamp_types}
\alias{lamp_types}
\alias{incandescent_lamps}
\alias{fluorescent_lamps}
\alias{led_lamps}
\alias{mercury_lamps}
\alias{multimetal_lamps}
\alias{sodium_lamps}
\alias{xenon_lamps}
\title{Spectral data for Lamps of different types}
\format{
A vector of character strings.

An object of class \code{character} of length 3.

An object of class \code{character} of length 24.

An object of class \code{character} of length 33.

An object of class \code{character} of length 25.

An object of class \code{character} of length 1.

An object of class \code{character} of length 1.

An object of class \code{character} of length 4.
}
\usage{
lamp_types

incandescent_lamps

fluorescent_lamps

led_lamps

mercury_lamps

multimetal_lamps

sodium_lamps

xenon_lamps
}
\description{
Names of members of the \code{\link{lamps.mspct}} collection of spectra
grouped by the technology their are based on, i.e., type.
}
\details{
These vectors can be used to extract subsets of spectra from
  \code{lamps.mspct}.  One additional vector, \code{lamp_types} contains the 
  names used for types of lamps in the names and vectors.
}
\note{
In the case of LED-based lamps we include here only ready built
  commercially available lamps. In some cases assembled from multiple
  discrete LEDs, possible of mixed types and spectral output. For emission
  spectra for LEDs available as electronic components please see
  \code{\link[photobiologyLEDs]{photobiologyLEDs-package}}.
}
\examples{
lamp_types

sodium_lamps
multimetal_lamps
mercury_lamps
led_lamps

# select lamps emitting in the amber, yellow, orange region
lamps.mspct[sodium_lamps]

}
\seealso{
\code{\link{lamps.mspct}}

Other indexing vectors of names: 
\code{\link{lamp_brands}},
\code{\link{lamp_colors}},
\code{\link{lamp_uses}}
}
\concept{indexing vectors of names}
\concept{lamps by technology}
\keyword{datasets}
