#' @title Delta-T sensors
#'
#' @description A vector of names useful for extracting subsets of spectra from
#'   the \code{\link{sensors.mspct}} object.
#'
#' @format A character vector of names of members of the collection of spectra.
#'
#' @docType data
#' @keywords datasets
#'
#' @note
#' Spectral data digitized from figure in manufacturer's manual.
#' These are typical measured data, and for specific sensor units the
#' calibration data supplied with the sensor must be used as individual
#' units may differ in their spectral response. Furthermore, the digigitizing
#' process from figures with a linear scale is prone to errors, which
#' are specially noticeable in regions of low responsivity.
#'
#' Manufacturer: Delta-T Devices Ltd, CAMBRIDGE CB25 0EJ, UK
#' \url{https://delta-t.co.uk/}
#'
#' @references
#' Manufacturer's User Manual Version: 1.0 dated Nov 2010
#'
#' @examples
#' deltat_sensors
#'
"deltat_sensors"
