% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gendist_distribution.R
\name{gendist_distribution}
\alias{gendist_distribution}
\title{Calculate genetic distance distribution}
\usage{
gendist_distribution(
  mut_rate,
  mean_gens_pdf,
  max_link_gens = 1,
  max_gens = NULL,
  max_dist = NULL
)
}
\arguments{
\item{mut_rate}{mean number of mutations per generation, assumed to be Poisson distributed}

\item{mean_gens_pdf}{the density distribution of the mean number of generations between cases;
the index of this vector is assumed to be the discrete distance between cases}

\item{max_link_gens}{the maximum generations of separation for linked pairs}

\item{max_gens}{the maximum number of generations to consider, if \code{NULL} (default) value is set to the highest
number of generations in mean_gens_pdf with a non-zero probability}

\item{max_dist}{the maximum distance to calculate, if \code{NULL} (default) value is set to max_gens * 99.9th percentile
of mut_rate Poisson distribution}
}
\value{
a data frame with distances and probabilities
}
\description{
Function calculates the distribution of genetic distances in a population of viruses
with the given parameters
}
\examples{
# ebola-like pathogen
R <- 1.5
mut_rate <- 1

# use simulated generation distributions from the provided 'genDistSim' data object
data('genDistSim')
mean_gens_pdf <- as.numeric(genDistSim[genDistSim$R == R, -(1:2)])

# get theoretical genetic distance dist based on mutation rate and generation parameters
gendist_distribution(mut_rate = mut_rate,
                     mean_gens_pdf = mean_gens_pdf,
                     max_link_gens = 1)

}
\seealso{
Other genetic distance functions: 
\code{\link{gendist_roc_format}()},
\code{\link{gendist_sensspec_cutoff}()}
}
\author{
Shirlee Wohl and Justin Lessler
}
\concept{genetic distance functions}
