% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translink_expected_links_obs.R
\name{translink_expected_links_obs}
\alias{translink_expected_links_obs}
\title{Calculate expected number of transmission links in a sample}
\usage{
translink_expected_links_obs(
  sensitivity,
  specificity,
  rho,
  M,
  R = NULL,
  assumption = "mtml"
)
}
\arguments{
\item{sensitivity}{scalar or vector giving the sensitivity of the linkage criteria}

\item{specificity}{scalar or vector giving the specificity of the linkage criteria}

\item{rho}{scalar or vector giving the proportion of the final outbreak size that is sampled}

\item{M}{scalar or vector giving the number of cases sampled}

\item{R}{scalar or vector giving the effective reproductive number of the pathogen (default=NULL)}

\item{assumption}{a character vector indicating which assumptions about transmission and linkage criteria. Default = \code{'mtml'}. Accepted arguments are:
\enumerate{
\item \code{'stsl'} for the single-transmission single-linkage assumption.
\item \code{'mtsl'} for the multiple-transmission single-linkage assumption.
\item \code{'mtml'} for the multiple-transmission multiple-linkage assumption.
}}
}
\value{
scalar or vector giving the expected number of observed links in the sample
}
\description{
This function calculates the expected number of observed pairs in the sample that are linked by the linkage criteria. The function requires the sensitivity
and specificity of the linkage criteria, and sample size \eqn{M}. Assumptions about transmission and linkage (single or multiple)
can be specified.
}
\examples{
# The simplest case: single-transmission, single-linkage, and perfect sensitivity
translink_expected_links_obs(sensitivity=1, specificity=0.9, rho=0.5, M=100, assumption='stsl')

# Multiple-transmission and imperfect sensitivity
translink_expected_links_obs(sensitivity=0.99, specificity=0.9, rho=1, M=50, R=1, assumption='mtsl')

# Small outbreak, larger sampling proportion
translink_expected_links_obs(sensitivity=0.99, specificity=0.95, rho=1, M=50, 
R=1, assumption='mtml')

# Large outbreak, small sampling proportion
translink_expected_links_obs(sensitivity=0.99, specificity=0.95, 
rho=0.05, M=1000, R=1, assumption='mtml')

}
\seealso{
Other transmission linkage functions: 
\code{\link{translink_expected_links_obs_mtml}()},
\code{\link{translink_expected_links_obs_mtsl}()},
\code{\link{translink_expected_links_obs_stsl}()},
\code{\link{translink_expected_links_true_mtml}()},
\code{\link{translink_expected_links_true_mtsl}()},
\code{\link{translink_expected_links_true_stsl}()},
\code{\link{translink_expected_links_true}()},
\code{\link{translink_fdr}()},
\code{\link{translink_prob_transmit_mtml}()},
\code{\link{translink_prob_transmit_mtsl}()},
\code{\link{translink_prob_transmit_stsl}()},
\code{\link{translink_prob_transmit}()},
\code{\link{translink_samplesize}()},
\code{\link{translink_tdr}()}
}
\author{
John Giles, Shirlee Wohl, and Justin Lessler
}
\concept{transmission linkage functions}
