% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/true_pairs_mtsl.R
\name{true_pairs_mtsl}
\alias{true_pairs_mtsl}
\title{Expected number of true transmission pairs assuming multiple-transmission and single-linkage}
\usage{
true_pairs_mtsl(eta, rho, M, R)
}
\arguments{
\item{eta}{scalar or vector giving the sensitivity of the linkage criteria}

\item{rho}{scalar or vector giving the proportion of the final outbreak size that is sampled}

\item{M}{scalar or vector giving the number of cases sampled}

\item{R}{scalar or vector giving the effective reproductive number of the pathogen}
}
\value{
scalar or vector giving the expected number of true transmission pairs in the sample
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
This function calculates the expected number true transmission pairs in a sample of size \code{M}.
The multiple-transmission and single-linkage method assumes the following:
\enumerate{
\item Each case \eqn{i} is, on average, the infector of \code{R} cases in the population (\eqn{N})
\item Each case \eqn{i} is allowed to be linked by the linkage criteria to only one other case \eqn{j} in the sampled population (\eqn{M}).
}
}
\examples{
true_pairs_mtsl(eta=0.95, rho=0.2, M=200, R=1)

}
\seealso{
Other true_pairs: 
\code{\link{true_pairs_mtml}()},
\code{\link{true_pairs_stsl}()},
\code{\link{true_pairs}()}
}
\author{
John Giles, Shirlee Wohl and Justin Lessler
}
\concept{true_pairs}
