% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lipa.R
\name{lipaMoran}
\alias{lipaMoran}
\title{Local Indicator of Phylogenetic Association}
\usage{
lipaMoran(
  p4d,
  trait = names(tdata(p4d)),
  reps = 999,
  alternative = "greater",
  prox.phylo = "patristic",
  as.p4d = FALSE
)
}
\arguments{
\item{p4d}{a \code{phylo4d} object.}

\item{trait}{the traits in the \code{phylo4d} object for which to compute LIPA.
Can be a character vector giving the name of the traits
or numbers giving the column in the table of the data slot of the \code{phylo4d} object.}

\item{reps}{a numeric value. Number of repetitions for the estimation of p.values with randomization.}

\item{alternative}{a character string specifying the alternative hypothesis for the tests.
Must be one of \code{greater} (default), \code{two-sided} or \code{less}.}

\item{prox.phylo}{a matrix of phylogenetic proximities or
a character string specifying a method to compute it.
See Details.}

\item{as.p4d}{logical. Should the results returned as a \code{phylo4d} object?}
}
\value{
If \code{as.p4d} is \code{FALSE} (default), the function returns a list:
\describe{
  \item{lipa}{A matrix of LIPA indices computed for each tip of the tree and each trait.}
  \item{p.value}{A matrix of p-values (tests of LIPA indices)}
  \item{reps}{Number of permutations for the tests}
  \item{alternative}{Alternative hypothesis for the tests}
}
If \code{as.p4d} is \code{TRUE}, the function returns a \code{phylo4d} object
with LIPA values as tips associated data.
}
\description{
This function computes Local Indicator of Phylogenetic Association (local Moran's I)
for each tip of a tree.
Tests are based on permutations.
}
\details{
If "\code{prox.phylo}" is a character string,
the phylogenetic proximity matrix is computed internally
using the function \code{\link[adephylo]{proxTips}} from the package \pkg{adephylo}.
Different methods are available:
"\code{patristic}","\code{nNodes}","\code{Abouheif}" and "\code{sumDD}".
See \code{\link[adephylo]{proxTips}} for details about the methods.
}
\references{
Anselin L. (1995) Local Indicators of Spatial Association-LISA. Geographical Analysis 27, 93-115.
}
