% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic_cal.R
\name{summary.logistic_cal}
\alias{summary.logistic_cal}
\title{Summarize a logistic_cal object}
\usage{
\method{summary}{logistic_cal}(object, conf_level = 0.95, ...)
}
\arguments{
\item{object}{a \code{logistic_cal} object}

\item{conf_level}{width of the confidence interval (0.95 gives 95\% CI)}

\item{...}{ignored}
}
\value{
estimates and conf_level*100 confidence intervals for calibration intercept and calibration slope.
The former is estimated from a \code{glm} (family = binomial("logit")) where the linear predictor (logit(p)) is included as an offset.
Results of the three likelihood ratio tests described by Miller et al. (2013) (see details).
}
\description{
Summarize a logistic_cal object
}
\details{
The likelihood ratio tests proposed by Miller et al. test the following: The first assesses weak calibration
overall by testing the null hypothesis that the intercept (a) and slope (b) are equal to 0 and 1, respectively.
The second assesses calibration in the large and tests the intercept against 0 with the slope fixed to 1. The third test
assesses the calibration slope after correcting for calibration in the large (by estimating a new intercept term). Note the
p-values from the calibration intercept and calibration slope estimates will typically agree with the p-values from
the second and third likelihood ratio tests but will not always match perfectly as the former are based on z-statistics and
the latter are based on log likelihood differences (chi-squared statistics).
}
\references{
Miller, M. E., Langefeld, C. D., Tierney, W. M., Hui, S. L., & McDonald, C. J. (1993). Validation of probabilistic predictions. Medical Decision Making, 13(1), 49-57.
}
