% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pocket_delete.R
\name{pocket_delete}
\alias{pocket_delete}
\title{pocket_delete}
\usage{
pocket_delete(
  item_ids,
  consumer_key = Sys.getenv("POCKET_CONSUMER_KEY"),
  access_token = Sys.getenv("POCKET_ACCESS_TOKEN")
)
}
\arguments{
\item{item_ids}{character vector. Pocket item ids you want to delete from your list.}

\item{consumer_key}{character. Your Pocket consumer key. Defaults to Sys.getenv("POCKET_CONSUMER_KEY").}

\item{access_token}{character. Your Pocket request token. Defaults to Sys.getenv("POCKET_ACCESS_TOKEN").}
}
\value{
Invisibly returns a list containing information on whether the action failed or succeeded, including the respective item ID.
}
\description{
delete items from your Pocket list.
}
\details{
This function uses the \code{modify} endpoint of the Pocket API which exhibits some weird behaviour. 
For example, even if a `modify` action is not successful, the API will still return "success". 
See [issue [#26](https://github.com/CorrelAid/pocketapi/issues/26) for a discussion.
}
