% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pocket_tag.R
\name{pocket_tag}
\alias{pocket_tag}
\title{pocket_tag}
\usage{
pocket_tag(
  action_name = c("tags_replace", "tags_remove", "tags_add", "tags_clear",
    "tag_rename", "tag_delete"),
  item_ids = NULL,
  tags = NULL,
  consumer_key = Sys.getenv("POCKET_CONSUMER_KEY"),
  access_token = Sys.getenv("POCKET_ACCESS_TOKEN")
)
}
\arguments{
\item{action_name}{character vector. The kind of tag action you want to undertake. Possible values: 'tags_add', 'tags_remove', 'tags_replace', 'tags_clear', 'tag_rename', or 'tag_delete'.}

\item{item_ids}{character vector. Pocket item ids you want to modify the tags for.}

\item{tags}{character vector. The names of the tags to work with the chosen action.}

\item{consumer_key}{character. Your Pocket consumer key. Defaults to Sys.getenv("POCKET_CONSUMER_KEY").}

\item{access_token}{character. Your Pocket request token. Defaults to Sys.getenv("POCKET_ACCESS_TOKEN").}
}
\description{
modify the tags of the items in pocket.
}
\details{
This function uses the \code{modify} endpoint of the Pocket API which exhibits some weird behaviour. 
For example, even if a `modify` action is not successful, the API will still return "success". 
See [issue [#26](https://github.com/CorrelAid/pocketapi/issues/26) for a discussion.
}
