% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4classes.R, R/bundle.R, R/corpus.R
\docType{class}
\name{bundle-class}
\alias{bundle-class}
\alias{bundle}
\alias{[[,bundle-method}
\alias{[[<-,bundle-method}
\alias{name<-,bundle-method}
\alias{length,bundle-method}
\alias{names,bundle-method}
\alias{names<-,bundle,vector-method}
\alias{unique,bundle-method}
\alias{+,bundle,bundle-method}
\alias{+,bundle,textstat-method}
\alias{[,bundle,ANY,ANY,ANY-method}
\alias{$,bundle-method}
\alias{$<-,bundle-method}
\alias{sample,bundle-method}
\alias{as.bundle,list-method}
\alias{as.bundle,textstat-method}
\alias{as.data.table.bundle}
\alias{as.matrix,bundle-method}
\alias{subset,bundle-method}
\alias{as.list,bundle-method}
\alias{as.list.bundle}
\alias{get_corpus,bundle-method}
\title{Bundle Class}
\usage{
\S4method{name}{bundle}(x) <- value

\S4method{length}{bundle}(x)

\S4method{names}{bundle}(x)

\S4method{names}{bundle,vector}(x) <- value

\S4method{unique}{bundle}(x)

\S4method{+}{bundle,bundle}(e1, e2)

\S4method{+}{bundle,textstat}(e1, e2)

\S4method{[[}{bundle}(x, i)

\S4method{[}{bundle,ANY,ANY,ANY}(x, i)

\S4method{[[}{bundle}(x, i) <- value

\S4method{$}{bundle}(x, name)

\S4method{$}{bundle}(x, name) <- value

\S4method{sample}{bundle}(x, size)

\S4method{as.bundle}{list}(object, ...)

\S4method{as.bundle}{textstat}(object)

\method{as.data.table}{bundle}(x, keep.rownames, col, ...)

\S4method{as.matrix}{bundle}(x, col)

\S4method{subset}{bundle}(x, ...)

\S4method{as.list}{bundle}(x)

\method{as.list}{bundle}(x, ...)

\S4method{get_corpus}{bundle}(x)
}
\arguments{
\item{x}{a bundle object}

\item{value}{character string with a name to be assigned}

\item{e1}{object 1}

\item{e2}{object 2}

\item{i}{\code{integer} or \code{character} values for indexing a bundle object.}

\item{name}{The name of an object in the \code{bundle} object.}

\item{size}{number of items to choose to generate a sample}

\item{object}{A \code{bundle} object.}

\item{...}{Further parameters}

\item{keep.rownames}{Required argument to safeguard consistency with S3
method definition in the \code{data.table} package. Unused in this context.}

\item{col}{columns of the \code{data.table} to use to generate an object.}
}
\description{
A \code{bundle} is used to combine several objects (\code{partition}, \code{context},
\code{features}, \code{cooccurrences} objects) into one S4 class object. Typically, a
class inheriting from the \code{bundle} superclass will be used. When working with
a \code{context_bundle}, a \code{features_bundle}, a \code{cooccurrences_bundle}, or a
\code{context_bundle}, a similar set of standard methods is available to perform
transformations.
}
\section{Slots}{

\describe{
\item{\code{corpus}}{The CWB corpus the xobjects in the \code{bundle} are based on, a
length 1 \code{character} vector.}

\item{\code{objects}}{An object of class \code{list}.}

\item{\code{p_attribute}}{Object of class \code{character}.}

\item{\code{encoding}}{The encoding of the corpus.}
}}

\examples{
use("RcppCWB", "REUTERS")

# generate bundle with articles in REUTERS corpus
b <- partition_bundle("REUTERS", s_attribute = "id")

# basic operations
length(b)
names(b)
get_corpus(b)
summary(b)

# enrich with count for p-attribute
b <- enrich(b, p_attribute = "word")

# Indexing and accessing bundle objects
reu <- corpus("REUTERS") \%>\% split(s_attribute = "id")
reu[1:3]
reu[-1]
reu[-(1:10)]
reu["127"]
reu$`127` # alternative access
reu[c("127", "273")]
reu[["127"]] <- NULL
pb <- partition_bundle("GERMAPARLMINI", s_attribute = "party")
pb$"NA" <- NULL # quotation needed if name is "NA"

# Turn bundle into data.table (not tested to save time)
\donttest{
dt <- partition_bundle("REUTERS", s_attribute = "id") \%>\%
  cooccurrences(query = "oil", cqp = FALSE) \%>\%
  as.data.table(col = "ll")
}
}
\author{
Andreas Blaette
}
