% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4classes.R, R/corpus.R, R/info.R
\docType{methods}
\name{corpus-methods}
\alias{corpus-methods}
\alias{name,corpus-method}
\alias{get_corpus,corpus-method}
\alias{show,corpus-method}
\alias{$,corpus-method}
\alias{get_info,corpus-method}
\alias{show_info,corpus-method}
\title{Corpus class methods}
\usage{
\S4method{name}{corpus}(x)

\S4method{get_corpus}{corpus}(x)

\S4method{show}{corpus}(object)

\S4method{$}{corpus}(x, name)

\S4method{get_info}{corpus}(x)

\S4method{show_info}{corpus}(x)
}
\arguments{
\item{x}{An object of class \code{corpus}, or inheriting from it.}

\item{object}{An object of class \code{corpus}, or inheriting from it.}

\item{name}{A (single) s-attribute.}
}
\description{
A set of generic methods is available to extract basic information from
objects of the \code{corpus} class.
}
\details{
A \code{corpus} object can have a name, which can be retrieved using
the \code{name}-method.

Use \code{get_corpus()}-method to get the corpus ID from the slot
\code{corpus} of the \code{corpus} object.

The \code{show()}-method will show basic information on the
\code{corpus} object.

Applying the \code{$}-method on a corpus will return the values for the
s-attribute stated with argument \code{name}.

Use \code{get_info} to get the the content of the info file for the
corpus (usually in the data directory of the corpus) and return it as a
\code{character} vector. Returns \code{NULL} if there is not info file.

The \code{show_info}-method will get the content of the info
file for a corpus, turn it into an html document, and show the result in
the viewer pane of RStudio. If the filename of the info file ends on "md",
the document is rendered as markdown.
}
\examples{
# get/show information on corpora
corpus("REUTERS") \%>\% get_info()
corpus("REUTERS") \%>\% show_info()
corpus("GERMAPARLMINI") \%>\% get_info()
corpus("GERMAPARLMINI") \%>\% show_info()

use(pkg = "RcppCWB", corpus = "REUTERS")

# show-method
if (interactive()) corpus("REUTERS") \%>\% show()
if (interactive()) corpus("REUTERS") # show is called implicitly

# get corpus ID
corpus("REUTERS") \%>\% get_corpus()

# use $ to access corpus properties
use("polmineR")
g <- corpus("GERMAPARLMINI")
g$date
corpus("GERMAPARLMINI")$build_date #
gparl <- corpus("GERMAPARLMINI")
gparl$version \%>\%
  as.numeric_version()

}
