% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ind_wcumul.R
\encoding{UTF-8}
\name{ind_wcumul}
\alias{ind_wcumul}
\title{Assess polypharmacy based on the number of distinct medications consumed weighted to their respective duration of consumption}
\usage{
ind_wcumul(
  processed_tab,
  stats = c("mean", "sd", "min", "p5", "p10", "p25", "median", "p75", "p90", "p95",
    "max")
)
}
\arguments{
\item{processed_tab}{Table of individual drug treatments over the study period. Created by \code{\link{data_process}} function.}

\item{stats}{Cohort descriptive statistics to calculate on the polypharmacy indicator. See \emph{Details} for possible values.}
}
\value{
\code{list}:
\itemize{
\item \code{indic}: \code{data.table} indicating each \code{stats} (columns).
\item \code{stats_id}: \code{data.table} indicating the number of drugs use for each individual (all cohort).
}
}
\description{
Calculates the number of distinct medications weighted by the duration of consumption that are consumed by every individual and provides cohort descriptive statistics on this indicator.
}
\details{
\strong{stats:} Possible values are
\itemize{
\item \code{'mean'}, \code{'min'}, \code{'median'}, \code{'max'}, \code{'sd'};
\item \code{'pX'} where \emph{X} is an integer value in ]0, 100];
\item \code{'q1'}=\code{'p25'}, \code{'q2'}=\code{'p50'}=\code{'median'}, \code{q3}=\code{'p75'}.
}
}
\examples{
rx1 <- data.frame(id = c(1, 1, 1, 2),
                  code = c("A", "B", "C", "A"),
                  date = c("2000-01-01", "2000-01-01", "2000-01-26", "2000-01-17"),
                  duration = c(30, 5, 5, 10))
cohort1 <- data.frame(id = as.numeric(1:3),
                      age = c(45, 12, 89),
                      sex = c("F", "F", "M"))
rx_proc1 <- data_process(Rx_deliv = rx1, Rx_id = "id", Rx_drug_code = "code",
                         Rx_drug_deliv = "date", Rx_deliv_dur = "duration",
                         Cohort = cohort1, Cohort_id = "id",
                         study_start = "2000-01-01", study_end = "2000-01-30",
                         cores = 1)
dt_ind_wcumul <- ind_wcumul(processed_tab = rx_proc1)
}
