% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/associate_dyes.R
\name{associate_dyes}
\alias{associate_dyes}
\title{Associate Dye Names in Batch Import Output}
\usage{
associate_dyes(x, y)
}
\arguments{
\item{x}{The Output list of data frames from fsa_batch_imp.}

\item{y}{The path to the folder from the current directory where the
.fsa files that will be analyzed are stored.}
}
\value{
The input dataframe with an added column assigning fluorescent
dye colors.
}
\description{
This function associates dye info with fragman channel names. It was
designed to be performed on any fsa formats after final columns are
correctly imported.
}
\examples{
y <- system.file("extdata", package = "pooledpeaks")
x <- fsa_batch_imp(y, channels = 5, fourier = FALSE, saturated = FALSE ,
lets.pullup = FALSE, plotting = FALSE, rawPlot = FALSE,
llength = 3000, ulength = 80000 )
associate_dyes(x,y)
}
