% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{compute_F4DfromF2samples}
\alias{compute_F4DfromF2samples}
\alias{.compute_F4DfromF2samples}
\title{compute_F4DfromF2samples}
\usage{
.compute_F4DfromF2samples(blockF2, blockDenom, npops, verbose)
}
\arguments{
\item{blockF2}{Numeric Matrix with nF2=(npop*(npop-1))/2 rows and nblocks columns matrix containing pairwise-pop F2 estimates for each block-jackknife sample (l.o.o.)}

\item{blockDenom}{Numeric Matrix with nF4=(npops*(npops-1)/2)*((npops-2)*(npops-3)/2)/2 rows and nblocks containing the estimates of the denominator of Dstat (see compute_blockDdenom) for each block-jackknife sample (l.o.o.)}

\item{npops}{Integer giving the number of populations}

\item{verbose}{Logical (if TRUE progression bar is printed on the terminal)}
}
\value{
Return a matrix with nF4=(npops*(npops-1)/2)*((npops-2)*(npops-3)/2)/2 rows and four columns corresponding to the mean and the s.e. of F4 and the mean and s.e. of Dstat
}
\description{
Compute all F4 and Dstat from F2 values obtained from each block-jackknife bloc
}
\details{
Compute F4 and D estimates and their s.e. based on block-jackknife estimates of all F2 (and heterozygosities)
}
\examples{
#
}
