% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/out.objects.R
\docType{class}
\name{pairwisefst-class}
\alias{pairwisefst-class}
\alias{pairwisefst}
\title{S4 class to represent a pairwise Fst results obtained with the compute.pairwiseFST}
\description{
S4 class to represent a pairwise Fst results obtained with the compute.pairwiseFST
}
\section{Slots}{

\describe{
\item{\code{values}}{A data frame with npop*(npop-1)/2 rows and 3 (or 7 if blockjackknife is TRUE) columns containing for both the Fst and Q2, estimates over all the SNPs and if blockjackknife=TRUE, the estimated block-jackknife and standard error (s.e.). The seventh (or third if blockjackknife=FALSE) column gives the number of SNPs.}

\item{\code{PairwiseFSTmatrix}}{A npxnp matrix containing the pairwise FST estimates}

\item{\code{PairwiseSnpFST}}{A matrix (nsnp rows and npops columns) with read count data for the reference allele}

\item{\code{PairwiseSnpQ1}}{A matrix (nsnp rows and npops columns) with overall read coverage}

\item{\code{PairwiseSnpQ2}}{A matrix (nsnp rows and 4 columns) detailing for each SNP, the chromosome (or scaffold), the position, allele 1 and allele 2}

\item{\code{blockjacknife}}{A logical indicating whether block-jackknife estimates of standard errors are available (TRUE) or not (FALSE)}
}}

\seealso{
To generate pairwise object, see \code{\link{compute.pairwiseFST}}
}
