% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_definitions.R
\name{plot.survmean}
\alias{plot.survmean}
\title{Graphically Inspect Curves Used in Mean Survival Computation}
\usage{
\method{plot}{survmean}(x, ...)
}
\arguments{
\item{x}{a \code{survmean} object}

\item{...}{arguments passed (ultimately) to \code{matlines}; you
may, therefore, supply e.g. \code{xlab} through this, though arguments
such as \code{lty} and \code{col} will not work}
}
\value{
Always returns \code{NULL} invisibly.
This function is called for its side effects.
}
\description{
Plots the observed (with extrapolation) and expected survival
curves for all strata in an object created by \verb{[survmean]}
}
\details{
For examples see \verb{[survmean]}. This function is intended only
for graphically inspecting that the observed survival curves with extrapolation
and the expected survival curves have been sensibly computed in \code{survmean}.

If you want finer control over the plotted curves, extract the curves from
the \code{survmean} output using

\code{attr(x, "curves")}

where \code{x} is a \code{survmean} object.
}
\seealso{
Other survmean functions: 
\code{\link{Surv}()},
\code{\link{lines.survmean}()},
\code{\link{survmean}()}
}
\author{
Joonas Miettinen
}
\concept{survmean functions}
