% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp_vgi.R
\name{pp_vgi}
\alias{pp_vgi}
\title{Download and Count OSM Features Over Target}
\usage{
pp_vgi(x, key)
}
\arguments{
\item{x}{an object of class \code{sf} that is used to interpolate data
to. Usually, x may include polygon features representing building units}

\item{key}{osm feature key (quoted) see \link[osmdata]{available_features}}
}
\value{
an object of class \code{sf} including OSM features
}
\description{
Download and Count OSM Features Over Target
}
\examples{
\dontrun{
    data('trg')

    # example using just a key
    pp_vgi(trg, key = 'amenity')

    # example using two keys
    pp_vgi(trg, key = c('amenity', 'shop')
}

}
