% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4_classes.R
\name{fitted_marginals}
\alias{fitted_marginals}
\alias{fitted_marginals,portvine_roll-method}
\title{Accessor method for the fitted marginal models of \verb{(cond_)portvine_roll}
objects}
\usage{
fitted_marginals(roll, ...)

\S4method{fitted_marginals}{portvine_roll}(roll)
}
\arguments{
\item{roll}{Object of class \code{portvine_roll} or a child class}

\item{...}{Additional parameters for child class methods}
}
\value{
Named list with an entry for each asset containing a
\code{\link[rugarch:ugarchroll-methods]{rugarch::ugarchroll}} class object that encompasses the marginal model fit.
}
\description{
Extract the marginal models that are ARMA-GARCH models which were fitted
in a rolling
window fashion using \code{\link[rugarch:ugarchroll-methods]{rugarch::ugarchroll}}. For the residual analysis of
the models encompassed in such a \code{\link[rugarch:ugarchroll-methods]{rugarch::ugarchroll}} class object one
can have a look at the utility function \code{\link[=roll_residuals]{roll_residuals()}}.
}
\seealso{
\code{\linkS4class{portvine_roll}}, \code{\link[=roll_residuals]{roll_residuals()}}
}
