% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_estim.R
\name{poso_estim_map}
\alias{poso_estim_map}
\title{Estimate the Maximum A Posteriori individual parameters}
\usage{
poso_estim_map(
  dat = NULL,
  prior_model = NULL,
  return_model = TRUE,
  return_ofv = FALSE,
  nocb = FALSE
)
}
\arguments{
\item{dat}{Dataframe. An individual subject dataset following the
structure of NONMEM/rxode2 event records.}

\item{prior_model}{A \code{posologyr} prior population pharmacokinetics
model, a list of six objects.}

\item{return_model}{A boolean. Returns a rxode2 model using the estimated
ETAs if set to \code{TRUE}.}

\item{return_ofv}{A boolean. Returns a the Objective Function Value (OFV)
if set to \code{TRUE}.}

\item{nocb}{A boolean. for time-varying covariates: the next observation
carried backward (nocb) interpolation style, similar to NONMEM.  If
\code{FALSE}, the last observation carried forward (locf) style will be used.
Defaults to \code{FALSE}.}
}
\value{
A named list consisting of one or more of the following elements
depending on the input parameters of the function: \verb{$eta} a named vector
of the MAP estimates of the individual values of ETA, \verb{$model} an rxode2
model using the estimated ETAs, \verb{$event} the \code{data.table} used to solve the
returned rxode2 model.
}
\description{
Estimates the Maximum A Posteriori (MAP) individual parameters,
also known as Empirical Bayes Estimates (EBE).
}
\examples{
rxode2::setRxThreads(1) # limit the number of threads

# model
mod_run001 <- function() {
  ini({
    THETA_Cl <- 4.0
    THETA_Vc <- 70.0
    THETA_Ka <- 1.0
    ETA_Cl ~ 0.2
    ETA_Vc ~ 0.2
    ETA_Ka ~ 0.2
    prop.sd <- sqrt(0.05)
  })
  model({
    TVCl <- THETA_Cl
    TVVc <- THETA_Vc
    TVKa <- THETA_Ka

    Cl <- TVCl*exp(ETA_Cl)
    Vc <- TVVc*exp(ETA_Vc)
    Ka <- TVKa*exp(ETA_Ka)

    K20 <- Cl/Vc
    Cc <- centr/Vc

    d/dt(depot) = -Ka*depot
    d/dt(centr) = Ka*depot - K20*centr
    Cc ~ prop(prop.sd)
  })
}
# df_patient01: event table for Patient01, following a 30 minutes intravenous
# infusion
df_patient01 <- data.frame(ID=1,
                        TIME=c(0.0,1.0,14.0),
                        DV=c(NA,25.0,5.5),
                        AMT=c(2000,0,0),
                        EVID=c(1,0,0),
                        DUR=c(0.5,NA,NA))
# estimate the Maximum A Posteriori individual parameters
poso_estim_map(dat=df_patient01,prior_model=mod_run001)

}
