% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/po_extract.R
\name{po_extract}
\alias{po_extract}
\title{Extract messages for translation into a \code{.pot} file}
\usage{
po_extract(
  dir = ".",
  custom_translation_functions = list(),
  verbose = !is_testing(),
  style = NULL
)
}
\arguments{
\item{dir}{Character, default the present directory; a directory in which an
R package is stored.}

\item{custom_translation_functions}{A \code{list} with either/both of two
components, \code{R} and \code{src}, together governing how to extract any
non-standard strings from the package.

See Details in \code{\link[=translate_package]{translate_package()}}.}

\item{verbose}{Logical, default \code{TRUE} (except during testing). Should
extra information about progress, etc. be reported?}

\item{style}{Translation style, either \code{"base"} or \code{"explict"}.
The default, \code{NULL}, reads from the \code{DESCRIPTION} field
\code{Config/potools/style} so you can specify the style once for your
package.

Both styles extract strings explicitly flagged for translation with
\code{gettext()} or \code{ngettext()}. The base style additionally extracts
strings in calls to \code{stop()}, \code{warning()}, and \code{message()},
and to \code{stopf()}, \code{warningf()}, and \code{messagef()} if you have
added those helpers to your package. The explicit style also accepts
\code{tr_()} as a short hand for \code{gettext()}. See
\code{vignette("developer")} for more details.}
}
\value{
The extracted messages as computed by \code{\link[=get_message_data]{get_message_data()}},
invisibly.
}
\description{
\code{po_extract()} scans your package for strings to be translated and
saves them into a \code{.pot} template file (in the package's \code{po}
directory). You should never modify this file by hand; instead modify the
underlying source code and re-run \code{po_extract()}.

If you have existing translations, call \code{\link[=po_update]{po_update()}} after \code{\link[=po_extract]{po_extract()}}
to update them with the changes.
}
