% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generator.R
\name{generateDynppsbm}
\alias{generateDynppsbm}
\title{Dynppsbm data generator}
\usage{
generateDynppsbm(intens, Time, n, prop.groups, directed = TRUE)
}
\arguments{
\item{intens}{List of intensity functions \eqn{\alpha^{(q,l)}}, each one is a list of 2 components:
\itemize{
  \item \code{intens} : a positive function. The intensity function  \eqn{\alpha^{(q,l)}}
  \item \code{max} : positive real number. An upper bound on \eqn{\alpha^{(q,l)}}
}}

\item{Time}{Positive real number. [0,Time] is the total time interval of observation.}

\item{n}{Total number of nodes,  \eqn{1\le i \le n}.}

\item{prop.groups}{Vector of group proportions (probability to belong to a group), should be of length \eqn{Q}}

\item{directed}{Boolean for directed (TRUE) or undirected (FALSE) case.

If directed then \code{intens} should be of length \eqn{Q^2}, else of length \eqn{Q*(Q+1)/2}.}
}
\value{
Simulated data, latent group variables and intensities \eqn{\alpha^{(q,l)}}.
}
\description{
Generates data under the Dynamic Poisson Process Stochastic Blockmodel (dynppsbm).
}
\examples{
# Generate data from an undirected graph with n=10 individuals and Q=2 clusters

# equal cluster proportions
prop.groups <- c(0.5,0.5)

# 3 different intensity functions:
intens <- list(NULL)
intens[[1]] <- list(intens= function(x) 100*x*exp(-8*x),max=5)
    # (q,l) = (1,1)
intens[[2]] <- list(intens= function(x) exp(3*x)*(sin(6*pi*x-pi/2)+1)/2,max=13)
    # (q,l) = (1,2)
intens[[3]] <- list(intens= function(x) 8.1*(exp(-6*abs(x-1/2))-.049),max=8)
    # (q,l) = (2,2)

# generate data:
obs <- generateDynppsbm(intens,Time=1,n=10,prop.groups,directed=FALSE)

# latent variables (true clustering of the individuals)
obs$z

# number of time events:
length(obs$data$time.seq)

# number of interactions between each pair of individuals:
table(obs$data$type.seq)

}
\references{
MATIAS, C., REBAFKA, T. & VILLERS, F. (2018).  A semiparametric extension of the stochastic block model for longitudinal networks. Biometrika. 105(3): 665-680.
}
