% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnose_assertion_failure.R
\name{diagnose_assertion_failure}
\alias{diagnose_assertion_failure}
\alias{forwarded_arg_label}
\title{Implement a custom assertion}
\usage{
diagnose_assertion_failure(message, ..., .details)

forwarded_arg_label(arg)
}
\arguments{
\item{message}{diagnostic message to show (see \code{\link[rlang:format_error_bullets]{rlang::format_error_bullets()}})}

\item{...}{expressions to diagnose (forwarded to \code{\link[=diagnose_expressions]{diagnose_expressions()}})}

\item{.details}{an optional data frame with diagnosis data}

\item{arg}{a forwarded function argument}
}
\value{
\code{diagnose_assertion_failure()} always returns \code{FALSE}.
}
\description{
\code{diagnose_assertion_failure()} displays customized failure message and
diagnosis in assertions such as \code{\link[=precondition]{precondition()}}. This can be used to
implement assertion helpers. This function does nothing if invoked outside
an assertion (see details). The function \code{forwarded_arg_label()} looks up a
forwarded argument and formats it as a string (used in custom diagnostic
messages).
}
\details{
If invoked as part of an assertion (e.g. \code{\link[=precondition]{precondition()}}),
\code{diagnose_assertion_failure()} provides a custom failure message and
diagnosis. If invoked in any other context, the function does nothing. This
can be used to implement custom assertions helpers that behave like regular
binary predicates (functions) under normal circumstances and generate a
customized assertion failure report when used as part of an assertion
(see examples).

The first argument to \code{diagnose_assertion_failure()} is a character vector
with a custom failure message. This vector will be formatted as error
bullets via\code{\link[rlang:format_error_bullets]{rlang::format_error_bullets()}}. Any subsequent argument will be
forwarded to \code{diagnose_assertion_failure()} for diagnosis. For custom
diagnosis, the user can supply their own data frame with diagnosis details
via optional argument \code{.details}. The format of this data frame must be
identical to one returned by \code{diagnose_assertion_failure()}.

The function \code{forwarded_arg_label()} looks up a forwarded expression and
formats it as a single string suitable for inclusion in diagnostic
messages.
}
\examples{

# returns TRUE if x is a positive, integer, FALSE otherwise
# if invoked as part of an assertion displays a custom failure diagnosis
is_positive_int <- function(x) {
  is.integer(x) && length(x) == 1L && (x > 0) || {
    diagnose_assertion_failure(
      sprintf("`\%s` must be a positive integer", forwarded_arg_label(x)),
      {{x}}
    )
  }
}

# for all intends and purposes this is just a regular R function that returns
# TRUE or FALSE
is_positive_int(5L)
is_positive_int(-5L)

# guard to avoid throwing errors
if(FALSE) {

# ... but it will provide custom diagnosis if invoked inside an assertion
precondition(is_positive_int(-5L))

}
}
