% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlationFunctions.R
\name{pi.r.demo}
\alias{pi.r.demo}
\title{Simulation to demonstrate the meaning of the correlation prediction interval}
\usage{
pi.r.demo(n = 100, rep.n = NA, rho = 0.5, number.trials = 10000,
  prob.level = 0.95, bias.correction = FALSE)
}
\arguments{
\item{n}{Original study: Sample size}

\item{rep.n}{(optional) Replication study: Sample size. If not specified, n is used.}

\item{rho}{All samples are drawn from a common population. This specifies the population correlation.}

\item{number.trials}{Indicate the number of pairs of sample (original, replication) that should be used. 10,000 or higher suggested for stable results.}

\item{prob.level}{(optional 0 to 1 value) Probability level desired (0 to 1). If not specified .95 (i.e., 95 percent) will be used.}

\item{bias.correction}{Apply bias correction formula to d-values.}
}
\value{
The prediction interval capture percentage and related statistics in list format.
}
\description{
Simulation to demonstrate the meaning of the correlation prediction interval
}
\examples{
pi.r.demo(n=100,rho=.50,number.trials=10)
}

