% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rnbinom.R
\name{rnbinom}
\alias{rnbinom}
\title{Sampling of negative binomial data}
\usage{
rnbinom(n, lambda, kappa, offset = NULL)
}
\arguments{
\item{n}{defines the number of clusters (\eqn{I})}

\item{lambda}{defines the overall Poisson mean (\eqn{\lambda})}

\item{kappa}{dispersion parameter (\eqn{\kappa})}

\item{offset}{defines the number of experimental units per cluster (\eqn{n_i})}
}
\value{
\code{rnbinom()} returns a \code{data.frame} with two columns:
\code{y} as the observations and \code{offset} as the number of offsets per
observation.
}
\description{
\code{rnbinom()} samples negative-binomial data.
The following description of the sampling process is based on the parametrization
used by Gsteiger et al. 2013.
}
\details{
The variance of the negative-binomial distribution is
\deqn{var(Y_i) = n_i \lambda (1+ \kappa n_i \lambda).}
Negative-biomial observations can be sampled based on predefined values of \eqn{\kappa},
\eqn{\lambda} and \eqn{n_i}: \cr
Define the parameters of the gamma distribution as \eqn{a=\frac{1}{\kappa}} and
\eqn{b_i=\frac{1}{\kappa n_i \lambda}}. Then, sample the Poisson means for each cluster
\deqn{\lambda_i \sim Gamma(a, b_i).}
Finally, the observations \eqn{y_i} are sampled from the Poisson distribution
\deqn{y_i \sim Pois(\lambda_i)}
}
\examples{

# Sampling of negative-binomial observations
# with different offsets
set.seed(123)
rnbinom(n=5, lambda=5, kappa=0.13, offset=c(3,3,2,3,2))

}
\references{
Gsteiger, S., Neuenschwander, B., Mercier, F. and Schmidli, H. (2013):
Using historical control information for the design and analysis of clinical
trials with overdispersed count data. Statistics in  Medicine, 32: 3609-3622.
\doi{10.1002/sim.5851}
}
