% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aha_2012_conference_ptp.R
\name{calculate_aha_2012_tbl_9_ptp}
\alias{calculate_aha_2012_tbl_9_ptp}
\title{Calculate ACCF/AHA/ACP/AATS/PCNA/SCAI/STS 2012 PTP for obstructive CAD}
\usage{
calculate_aha_2012_tbl_9_ptp(
  age,
  sex,
  chest_pain_type,
  output = c("numeric", "percentage"),
  label_sex_male = c("male"),
  label_sex_female = c("female"),
  label_sex_unknown = c(NA, NaN),
  label_cpt_nonanginal = c("nonanginal"),
  label_cpt_atypical = c("atypical"),
  label_cpt_typical = c("typical"),
  label_cpt_unknown = c(NA, NaN)
)
}
\arguments{
\item{age}{Input integer value to indicate the age of the patient in years.}

\item{sex}{The value of variable in the parameters \code{label_sex_male},
\code{label_sex_female} and \code{label_sex_unknown}.}

\item{chest_pain_type}{The value of variable in the parameters,
\code{label_cpt_nonanginal}, \code{label_cpt_atypical}, \code{label_cpt_typical} and
\code{label_cpt_unknown}.}

\item{output}{Input text to indicate the how pre-test
probability results be expressed
Default: c("numeric", "percentage")
\itemize{
  \item numeric means the PTP will be expressed as an integer probability (0-100).
  \item percentage means the PTP will be expressed as percentage text (0-100\%).
}}

\item{label_sex_male}{Label(s) for definition(s) of male sex.
Default: \code{c("male")}}

\item{label_sex_female}{Label(s) for definition(s) of female sex.
Default: \code{c("female")}}

\item{label_sex_unknown}{Label(s) for definition(s) of missing sex.
Default: \code{c(NA, NaN)}}

\item{label_cpt_nonanginal}{Label(s) for patient having nonanginal or non-specific chest pain.
Default: \code{c("nonanginal")}}

\item{label_cpt_atypical}{Label(s) for patient having atypical chest pain.
Default: \code{c("atypical")}}

\item{label_cpt_typical}{Label(s) for patient having typical chest pain.
Default: \code{c("typical")}}

\item{label_cpt_unknown}{Label(s) for patient having unknown chest pain type symptoms.
Default: \code{c(NA, NaN)}}
}
\value{
An integer or percentage representing the patient's PTP for obstructive CAD
based on the ACCF/AHA/ACP/AATS/PCNA/SCAI/STS 2012 guidelines.
}
\description{
This function returns a patient's
pre-test Probability (PTP) of obstructive
coronary artery disease (CAD) based on the
American College of Cardiology Foundation,
American Heart Association,
American College of Physicians,
American Association for Thoracic Surgery,
Preventive Cardiovascular Nurses Association,
Society for Cardiovascular Angiography and Interventions,
and Society of Thoracic Surgeons 2012 guidelines.
}
\details{
The predictive model used to create the guidelines are based on
patients from the Diamond and Forrester and the Coronary Artery Surgery Study.
}
\examples{
# 35 year old female with typical chest pain
calculate_aha_2012_tbl_9_ptp(
    age = 35,
    sex = "female",
    chest_pain_type = "typical",
    output = "percentage"
)

# 65 year old male with nonanginal chest pain
calculate_aha_2012_tbl_9_ptp(
    age = 65,
    sex = "male",
    chest_pain_type = "nonanginal",
    output = "percentage"
)
}
