% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_filter_prevR.r
\name{st_filter_prevR}
\alias{st_filter_prevR}
\title{Spatial filter}
\usage{
st_filter_prevR(x, y)
}
\arguments{
\item{x}{object of class \link[sf:sf]{sf::sf}}

\item{y}{object of class \link[sf:sf]{sf::sf}}
}
\value{
Return \code{x} filtered by \code{y}
}
\description{
This function forces points of an object of class
\code{[}sf] located outside
the limits defined by an object of class \link[sp:SpatialPolygons-class]{sp::SpatialPolygons}
to \code{NA}.
}
\details{
The function try to apply \code{sf::st_filter()}. In case it fails,
it will try to rebuild \code{y} according to spherical geometry
(see \code{\link[sf:s2]{sf::st_as_s2()}}) before filtering. If it still fail, it will return
\code{x} unfiltered.
}
\seealso{
\code{\link[sf:st_join]{sf::st_filter()}}.
}
\keyword{manip}
\keyword{spatial}
