% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tas_data.R
\docType{data}
\name{tas_data}
\alias{tas_data}
\alias{get_tas_features}
\alias{get_tas_pu}
\alias{tas_features}
\alias{tas_pu}
\title{Tasmania data}
\format{
\describe{
\item{tas_pu}{\code{\link[sf:sf]{sf::st_sf()}} object.}
\item{tas_features}{\code{\link[terra:rast]{terra::rast()}} object}
}
}
\usage{
get_tas_pu()

get_tas_features()
}
\description{
Conservation planning dataset for Tasmania, Australia.
}
\details{
The following functions are provided to import data:

\describe{

\item{\code{get_tas_pu}}{Import planning unit data.
The planing units are a \code{\link[sf:sf]{sf::st_sf()}} simple features object.
Each row corresponds to a different planning unit, and columns
contain information about the planning units.
It has columns that contain: (\code{"id"}) unique identifiers and
(\code{"cost"}) unimproved land values for the planning units.
It also contains columns (\code{"locked_in"} and \code{"locked_out"})
with \code{logical} values (i.e. \code{TRUE} or \code{FALSE} values)
for locking in and locking out planning units.
These data obtained from the
\href{https://marxansolutions.org/}{"Introduction to \emph{Marxan}" course}
and were originally generated as part of a larger spatial prioritization
Resources (Klein \emph{et al.} 2007).}

\item{\code{get_tas_features}}{Import biodiversity feature data.
The feature data are a multi-layer \code{\link[terra:rast]{terra::rast()}} object.
classes. Each layer corresponds to a
different vegetation class and contains binary cell values that indicate
the presence or absence of the vegetation class.
These data were obtained from the Australian Government's National
Vegetation Information System (Australian Government Department of Climate
Change, Energy, the Environment and Water 2020).}

}
}
\examples{
# load packages
library(terra)
library(sf)

# load data
tas_pu <- get_tas_pu()
tas_features <- get_tas_features()

# preview planning units
print(tas_pu)
plot(tas_pu)

# plot features
print(tas_features)
plot(tas_features)

}
\references{
Klein C, Carwardine J, Wilson K, Watts M, and Possingham H (2007) \emph{Spatial
Prioritization Approaches for the Conservation of Biodiversity in
Australia: Considering Conservation Costs, Ecological & Evolutionary
Processes, and Large-Intact Areas.} Report to the Department of
Environment; Water Resources.

Australian Government Department of Climate Change, Energy, the Environment
and Water (2020). National Vegetation Information System. Version 6.0.
Available at \url{http://environment.gov.au/fed/catalog/search/resource/details.page?uuid=\%7B3F8AD12F-8300-45EC-A41A-469519A94039\%7D}.
}
\keyword{datasets}
