% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/se_meanx.R, R/se_rxy.R, R/se_sx.R
\name{se_meanx}
\alias{se_meanx}
\alias{se_rxy}
\alias{se_sx}
\title{Asymptotic Standard Errors}
\usage{
se_meanx(x, na.rm = FALSE)

se_rxy(x, y, na.rm = FALSE)

se_sx(x, na.rm = FALSE)
}
\arguments{
\item{x}{A numeric vector, representing a sample from a population}

\item{na.rm}{A boolean, whether or not to remove any \code{NA}s (default \code{FALSE})}

\item{y}{A numeric vector, representing a sample of a different variable}
}
\value{
A number representing the asymptotic standard error of the
particular estimate
}
\description{
These functions calculate the asymptotic standard errors of
common statistical estimates. \code{se_meanx} calculates the
standard error of the mean, \code{se_sx} calculates the standard
error of the population standard deviation estimate, and
\code{se_rxy} calculate the standard error of the correlation
estimate between two vectors.
}
\examples{
# calculate the mean and se of the mean of wage in the cps data
paste(
  "The average wage is",
  mean(cps$wagehr, na.rm = TRUE),
  "with a margin of error of",
  se_meanx(cps$wagehr, na.rm = TRUE)
)

}
