% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/followup.R
\name{followup}
\alias{followup}
\title{Estimation of the median potential followup time.}
\usage{
followup(formula, cens.code = 0, data, ...)
}
\arguments{
\item{formula}{A formula whose left hand side is a \code{Hist} or a 
\code{\link[survival]{Surv}} object specifying the event time
and the event type where by default 0=censored, 1=event, 2=competing risk (if any).
Use \code{cens.code} to change the value for censored.}

\item{cens.code}{Value of the event}

\item{data}{A data.frame in which all the variables of
\code{formula} can be interpreted.}

\item{...}{Arguments passed to \code{prodlim.quantile}.}
}
\value{
The estimated median potential followup time with inter quartile ranges.
}
\description{
The reverse Kaplan-Meier method estimates the median potential followup time.
}
\details{
This is merely a wrapper for \code{prodlim} with argument reverse.
}
\examples{
set.seed(8)
d <- SimCompRisk(117)

# overall
followup(Hist(time,event)~1,data=d)

# in strata defined by variable X1 
followup(Hist(time,event)~X1,data=d)
}
\references{
Michael Schemper and Terry L. Smith. A note on quantifying follow-up in studies of failure time. Controlled Clinical Trials, 17(4):343--346, 1996.
}
\seealso{
\code{\link{prodlim}}
}
\author{
Thomas A. Gerds <tag@biostat.ku.dk>
}
