% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/record.R
\name{record_rprof}
\alias{record_rprof}
\title{Profile R code and record Rprof samples.}
\usage{
record_rprof(expr, seconds_timeout = Inf, rprof = tempfile(), ...)
}
\arguments{
\item{expr}{An R expression to profile.}

\item{seconds_timeout}{Maximum number of seconds of elapsed time
to profile \code{expr}. When the timeout is reached, \code{proffer} stops running
\code{expr} and returns the profiling samples taken during the
\code{seconds_timeout} time window.}

\item{rprof}{Path to a file with Rprof samples.
Also returned from the function.}

\item{...}{Additional arguments passed on to \code{\link[=Rprof]{Rprof()}}.}
}
\value{
Path to a file with Rprof samples.
}
\description{
Run R code and record Rprof samples.
}
\examples{
if (identical(Sys.getenv("PROFFER_EXAMPLES"), "true")) {
# Returns a path to Rprof samples.
record_rprof(replicate(1e2, sample.int(1e4)))
}
}
