% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_crossovers.R
\name{calculate_crossovers}
\alias{calculate_crossovers}
\title{Calculate the Number of Crossovers}
\usage{
calculate_crossovers(individual_df, n_trials, n_replicates)
}
\arguments{
\item{individual_df}{A data frame containing the individual dataset.}

\item{n_trials}{The total number of trials in the dataset (the number of rows)}

\item{n_replicates}{The total number of replicates in each trial (the number of columns - 2)}
}
\value{
The number of crossovers detected in the dataset.
}
\description{
Calculate the Number of Crossovers
}
\details{
This function calculates the number of crossovers in a dataset by comparing
the values of replicates across multiple trials. It assumes that missing
values (NAs) have been interpolated using the \code{clean_data} function.
}
\examples{
data <- matrix(
   c(
     1, 60, 1, 2, 3, 4, 5,   # No NA values
     1, 90, 9, NA, 4, NA, 2,  # NA Values in row
     1, 120, 3, 6, NA, NA, 9  # Consecutive NA values
    ),
    nrow = 3,
    byrow=TRUE
)
n_trials <- nrow(data)
n_replicates <- ncol(data) - 2
crossovers <- calculate_crossovers(data, n_trials, n_replicates)
cat("Number of crossovers:", crossovers, "\n")

}
\seealso{
\code{\link{clean_data}} for information on data cleaning.
}
