% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_dfs.R
\name{score_dfs}
\alias{score_dfs}
\title{Compute Profile Repeatability Score}
\usage{
score_dfs(id_list, df_list, n_replicates, n_trials, verbose = FALSE)
}
\arguments{
\item{id_list}{The list of the names of the individuals}

\item{df_list}{A list of data frames, each of which correspond to one of the names in the individual list}

\item{n_replicates}{The number of replicate columns (number of columns in a df in df_list)}

\item{n_trials}{The number of trials per individual (number of rows in a df in df_list)}

\item{verbose}{A boolean parameter the defaults to FALSE. Determines whether messages are printed.}
}
\value{
A dataframe of the calculated metrics. The column structure is as follows:

\if{html}{\out{<div class="sourceCode">}}\preformatted{     - Column 1: "individual" - the unique identifier of an individual or sample
     - Column 2: "n_crossings" - the calculated number of crossings.
     - Column 3: "max_variance" - the maximum of the variances of the replicate measurements at a single time for the individual or sample.
     - Column 4: "ave_variance" - the average of the variances of the replicate measurements at a single time for the individual or sample.
     - Column 5: "base_score" - the original, unnormalized profile repeatability score. Smaller numbers rank higher.
     - Column 6: "final_score" - the base score, normalized by the sigmoid function. Constrained to be between 0 and 1. Scores closer to 1 rank higher.
}\if{html}{\out{</div>}}
}
\description{
Compute Profile Repeatability Score
}
\details{
Works on multiple elements of data.

Splits the data into the data frame for a particular individual from
the id_list, then calculates metrics to compute the profile repeatability
score. Returns a data frame with the individuals name and the score.
}
\examples{
df <- data.frame(
    col_a = c('A', 'A', 'B', 'B'),
    col_b = c(5, 15, 5, 15),
    col_c = c(5, 10, 1, 2),
    col_d = c(10, 15, 3, 4)
  )
id_list <- unique(df[, 1])
individuals <- list()
for (i in 1:length(id_list)) {
  individuals[[i]] <- df[df[, 1] == id_list[i], ]
}
ret_df <- score_dfs(id_list=id_list, df_list=individuals, n_replicates=2, n_trials=2)
print(ret_df)

}
