% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn_npsdr.R
\name{npsdr}
\alias{npsdr}
\title{A unified Principal sufficient dimension reduction method via kernel trick}
\usage{
npsdr(
  x,
  y,
  loss = "svm",
  h = 10,
  lambda = 1,
  b = floor(length(y)/3),
  eps = 1e-05,
  max.iter = 100,
  eta = 0.1,
  mtype,
  plot = TRUE
)
}
\arguments{
\item{x}{data matrix}

\item{y}{either continuous or (+1,-1) typed binary response vector}

\item{loss}{pre-specified loss functions belongs to \code{"svm", "logit", "l2svm", "wsvm", "qr", "asls", "wlogit", "wl2svm", "lssvm", "wlssvm"}, and user-defined loss function object also can be used formed by inside double (or single) quotation mark. Default is 'svm'.}

\item{h}{the number of slices. default value is 10}

\item{lambda}{hyperparameter for the loss function. default value is 1}

\item{b}{number of basis functions for a kernel trick, floor(length(y)/3) is default}

\item{eps}{threshold for stopping iteration with respect to the magnitude of derivative, default value is 1.0e-4}

\item{max.iter}{maximum iteration number for the optimization process. default value is 30}

\item{eta}{learning rate for gradient descent method. default value is 0.1}

\item{mtype}{type of margin, either "m" or "r" refer margin and residual, respectively (See, Table 1 in the pacakge manuscript). When one use user-defined loss function this argument should be specified. Default is "m".}

\item{plot}{If \code{TRUE} then it produces scatter plots of \eqn{Y} versus the first sufficient predictor. The default is FALSE.}
}
\value{
An object with S3 class "npsdr". Details are listed below.
\item{\code{evalues}}{Eigenvalues of the estimated working matrix M.}
\item{\code{evectors}}{Eigenvectors of the estimated working matrix M, the first d leading eigenvectors consists
the basis of the central subspace.}
}
\description{
Principal Sufficient Dimension Reduction method
}
\examples{
\donttest{
set.seed(1)
n <- 200;
p <- 5;
x <- matrix(rnorm(n*p, 0, 2), n, p)
y <- 0.5*sqrt((x[,1]^2+x[,2]^2))*(log(x[,1]^2+x[,2]^2))+ 0.2*rnorm(n)
obj_kernel <- npsdr(x, y, plot=FALSE)
print(obj_kernel)
plot(obj_kernel)
}
}
\references{
Artemiou, A. and Dong, Y. (2016)
\emph{Sufficient dimension reduction via principal lq support vector machine,
 Electronic Journal of Statistics 10: 783–805}.\cr
 Artemiou, A., Dong, Y. and Shin, S. J. (2021)
\emph{Real-time sufficient dimension reduction through principal least
 squares support vector machines, Pattern Recognition 112: 107768}.\cr
 Kim, B. and Shin, S. J. (2019)
\emph{Principal weighted logistic regression for sufficient dimension
reduction in binary classification, Journal of the Korean Statistical Society 48(2): 194–206}.\cr
 Li, B., Artemiou, A. and Li, L. (2011)
\emph{Principal support vector machines for linear and
nonlinear sufficient dimension reduction, Annals of Statistics 39(6): 3182–3210}.\cr
Soale, A.-N. and Dong, Y. (2022)
\emph{On sufficient dimension reduction via principal asymmetric
 least squares, Journal of Nonparametric Statistics 34(1): 77–94}.\cr
 Wang, C., Shin, S. J. and Wu, Y. (2018)
\emph{Principal quantile regression for sufficient dimension
 reduction with heteroscedasticity, Electronic Journal of Statistics 12(2): 2114–2140}.\cr
 Shin, S. J., Wu, Y., Zhang, H. H. and Liu, Y. (2017)
\emph{Principal weighted support vector machines for sufficient dimension reduction in
 binary classification, Biometrika 104(1): 67–81}. \cr
 Li, L. (2007)
\emph{Sparse sufficient dimension reduction, Biometrika 94(3): 603–613}.
}
\seealso{
\code{\link{npsdr_x}}, \code{\link{psdr}}, \code{\link{rtpsdr}}
}
\author{
Jungmin Shin, \email{jungminshin@korea.ac.kr}, Seung Jun Shin, \email{sjshin@korea.ac.kr}, Andreas Artemiou \email{artemiou@uol.ac.cy}
}
