% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychrolib.R
\name{GetSatAirEnthalpy}
\alias{GetSatAirEnthalpy}
\title{Return saturated air enthalpy given dry-bulb temperature and pressure.}
\usage{
GetSatAirEnthalpy(TDryBulb, Pressure)
}
\arguments{
\item{TDryBulb}{A numeric vector of dry-bulb temperature in degreeF [IP] or degreeC [SI]}

\item{Pressure}{A numeric vector of atmospheric pressure in Psi [IP] or Pa [SI]}
}
\value{
A numeric vector of saturated air enthalpy in Btu lb-1 [IP] or J kg-1 [SI]
}
\description{
Return saturated air enthalpy given dry-bulb temperature and pressure.
}
\examples{
SetUnitSystem("IP")
GetSatAirEnthalpy(80:100, 14.696)

SetUnitSystem("SI")
GetSatAirEnthalpy(20:30, 101325)

}
\references{
ASHRAE Handbook - Fundamentals (2017) ch. 1
}
