% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychrolib.R
\name{GetTWetBulbFromHumRatio}
\alias{GetTWetBulbFromHumRatio}
\title{Return wet-bulb temperature given dry-bulb temperature, humidity ratio, and pressure.}
\usage{
GetTWetBulbFromHumRatio(TDryBulb, HumRatio, Pressure)
}
\arguments{
\item{TDryBulb}{A numeric vector of dry-bulb temperature in degreeF [IP] or degreeC [SI]}

\item{HumRatio}{A numeric vector of humidity ratio in lb_H2O lb_Air-1 [IP] or kg_H2O kg_Air-1 [SI]}

\item{Pressure}{A numeric vector of atmospheric Pressure in Psi [IP] or Pa [SI]}
}
\value{
A numeric vector of wet-bulb temperature in degreeF [IP] or degreeC [SI]
}
\description{
Return wet-bulb temperature given dry-bulb temperature, humidity ratio, and pressure.
}
\examples{
SetUnitSystem("IP")
GetTWetBulbFromHumRatio(80:100, 0.01, 14.175)

SetUnitSystem("SI")
GetTWetBulbFromHumRatio(20:30, 0.01, 95461)

}
\references{
ASHRAE Handbook - Fundamentals (2017) ch. 1 eqn 33 and 35 solved for Tstar
}
