% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pte.R
\name{compute.pte}
\alias{compute.pte}
\title{Heavy-Lifting for pte Function}
\usage{
compute.pte(ptep, subset_fun, attgt_fun, ...)
}
\arguments{
\item{ptep}{\code{pte_params} object}

\item{subset_fun}{This is a function that should take in \code{data},
\code{g} (for group), \code{tp} (for time period), and \code{...}
and be able to return the appropriate \code{data.frame} that can be used
by \code{attgt_fun} to produce ATT(g=g,t=tp).  The data frame should
be constructed using \code{gt_data_frame} in order to guarantee that
it has the appropriate columns that identify which group an observation
belongs to, etc.}

\item{attgt_fun}{This is a function that should work in the case where
there is a single group and the "right" number of time periods to
recover an estimate of the ATT.  For example, in the contest of
difference in differences, it would need to work for a single group,
find the appropriate comparison group (untreated units), find the right
time periods (pre- and post-treatment), and then recover an estimate
of ATT for that group.  It will be called over and over separately
by groups and by time periods to compute ATT(g,t)'s.

The function needs to work in a very specific way.  It should take in the
arguments: \code{data}, \code{...}.  \code{data} should be constructed
using the function \code{gt_data_frame} which checks to make sure
that \code{data} has the correct columns defined.
\code{...} are additional arguments (such as
formulas for covariates) that \code{attgt_fun} needs.  From these arguments
\code{attgt_fun} must return a list with element \code{ATT} containing the
group-time average treatment effect for that group and that time period.

If \code{attgt_fun} returns an influence function (which should be provided
in a list element named \code{inf_func}), then the code will use the
multiplier bootstrap to compute standard errors for group-time average
treatment effects, an overall treatment effect parameter, and a dynamic
treatment effect parameter (i.e., event study parameter).  If
\code{attgt_fun} does not return an influence function, then the same
objects will be computed using the empirical bootstrap.  This is usually
(perhaps substantially) easier to code, but also will usually be (perhaps
substantially) computationally slower.}

\item{...}{extra arguments that can be passed to create the correct subsets
of the data (depending on \code{subset_fun}), to estimate group time
average treatment effects (depending on \code{attgt_fun}), or to
aggregating treatment effects (particularly useful are \code{min_e},
\code{max_e}, and \code{balance_e} arguments to event study aggregations)}
}
\value{
a list containing the following elements:
\itemize{
\item \code{attgt.list}: list of ATT(g,t) estimates
\item \code{inffunc}: influence function matrix
\item \code{extra_gt_returns}: list of extra returns from gt-specific calculationsons
}
}
\description{
Function that actually computes panel treatment effects.
The difference relative to \code{compute.pte} is that this function
loops over time periods first (instead of groups) and tries to
estimate model for untreated potential outcomes jointly for all groups.
}
