% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_dose_gt.R
\name{dose_obj}
\alias{dose_obj}
\title{Class for Continuous Treatments}
\usage{
dose_obj(
  dose,
  overall_att = NULL,
  overall_att_se = NULL,
  overall_att_inffunc = NULL,
  overall_acrt = NULL,
  overall_acrt_se = NULL,
  overall_acrt_inffunc = NULL,
  att.d = NULL,
  att.d_se = NULL,
  att.d_crit.val = NULL,
  att.d_inffunc = NULL,
  acrt.d = NULL,
  acrt.d_se = NULL,
  acrt.d_crit.val = NULL,
  acrt.d_inffunc = NULL,
  pte_params = NULL
)
}
\arguments{
\item{dose}{vector containing the values of the dose used in estimation}

\item{overall_att}{estimate of the overall ATT, the mean of ATT(D) given D > 0}

\item{overall_att_se}{the standard error of the estimate of overall_att}

\item{overall_att_inffunc}{the influence function for estimating overall_att}

\item{overall_acrt}{estimate of the overall ACRT, the mean of ACRT(D|D) given D > 0}

\item{overall_acrt_se}{the standard error for the estimate of overall_acrt}

\item{overall_acrt_inffunc}{the influence function for estimating overall_acrt}

\item{att.d}{estimates of ATT(d) for each value of \code{dose}}

\item{att.d_se}{standard error of ATT(d) for each value of \code{dose}}

\item{att.d_crit.val}{critical value to produce pointwise or uniform confidence
interval for ATT(d)}

\item{att.d_inffunc}{matrix containing the influence function from estimating
ATT(d)}

\item{acrt.d}{estimates of ACRT(d) for each value of \code{dose}}

\item{acrt.d_se}{standard error of ACRT(d) for each value of \code{dose}}

\item{acrt.d_crit.val}{critical value to produce pointwise or uniform confidence
interval for ACRT(d)}

\item{acrt.d_inffunc}{matrix containing the influence function from estimating
ACRT(d)}

\item{pte_params}{a pte_params object containing other parameters passed to the function}
}
\value{
a \code{dose_obj} object
}
\description{
Holds results from computing dose-specific treatment effects
with a continuous treatment
}
