% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makespaghetti.R
\name{make.spaghetti}
\alias{make.spaghetti}
\title{Generate a spaghetti plot to visualize longitudinal data}
\usage{
make.spaghetti(x, y, id, group = NULL, data, col = NULL, pch = 16,
  lty = 1, lwd = 1, title = "", xlab = NA, ylab = NA,
  legend.title = "", xlim = NULL, ylim = NULL, cex.axis = 1,
  cex.title = 1, cex.lab = 1, cex.leg = 1, margins = NULL,
  legend.inset = -0.3, legend.space = 1)
}
\arguments{
\item{x}{the time variable (numeric vector)}

\item{y}{the longitudinal outcome (numeric vector)}

\item{id}{the subject indicator}

\item{group}{the group that each subject belongs to (optional, 
do not specify if not relevant)}

\item{data}{a data frame containing x, y, id and optionally group}

\item{col}{a vector of colors (optional)}

\item{pch}{dot type}

\item{lty}{line type}

\item{lwd}{line width}

\item{title}{plot title}

\item{xlab}{label for the x axis}

\item{ylab}{label for the y axis}

\item{legend.title}{legend title}

\item{xlim}{limits for the x axis}

\item{ylim}{limits for the y axis}

\item{cex.axis}{font size for the axes}

\item{cex.title}{title font size}

\item{cex.lab}{font size for axis labels}

\item{cex.leg}{font size for the legend}

\item{margins}{use this argument if you want to overwrite the default 
function margins}

\item{legend.inset}{moves legend more to the left / right (default is -0.3)}

\item{legend.space}{interspace between lines in the legend (default is 1)}
}
\description{
A spaghetti plot, or trajectory plot, is a plot that allows
to compare across individuals or groups the trajectories 
of a longitudinal outcome
}
\examples{
\donttest{
# generate example data
set.seed(123)
n = 12; t = 6
id = rep(1:n, each = t)
rand.int = rep(rnorm(n, sd = 0.5), each = t)
group = rep(c(0,1), each = n*t/2)
time = rep(0:(t-1), n)
offset = rnorm(n*t, sd = 0.3)
beta = c(3, 0, 0.1, 0.3)
X = model.matrix(~group + time + group*time)
mu = 2^(X \%*\% beta + rand.int + offset)
y = rpois(n*t, lambda = mu)
group = ifelse(group == 0, 'control', 'treatment')
data.long = data.frame(y, group, time, id, offset)
rm(list = setdiff(ls(), 'data.long'))

# create plot
make.spaghetti(x = time, y, id, group, 
data = data.long, title = 'spaghetti plot')
}
}
\references{
Signorelli, M., Spitali, P., Tsonaka, R. (2021). Poisson-Tweedie 
mixed-effects model: a flexible approach for the analysis of longitudinal RNA-seq
data. Statistical Modelling, 21 (6), 520-545. URL: https://doi.org/10.1177/1471082X20936017
}
\author{
Mirko Signorelli
}
