% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mock_predict_topology.R
\name{mock_predict_topology}
\alias{mock_predict_topology}
\title{Do a mock prediction of the topology of proteins}
\usage{
mock_predict_topology(fasta_filename)
}
\arguments{
\item{fasta_filename}{path to a FASTA file}
}
\value{
a \link[tibble]{tibble} with the columns 'name'
and 'topology', where the 'name' column hold all the proteins' names,
and 'topology' contains all respective topologies.
}
\description{
Uses \link{predict_topology} for doing a real prediction
}
\examples{
fasta_filename <- tempfile()
save_tibble_as_fasta_file(
  t = tibble::tibble(
    name = c("A", "B"),
    sequence = c("FAMILYVW", "VWFAMILY")
  ),
  fasta_filename = fasta_filename
)
mock_predict_topology(fasta_filename)
}
\author{
Richèl J.C. Bilderbeek
}
