% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pushbar.R
\name{pushbar}
\alias{pushbar}
\alias{pushbar_deps}
\alias{setup_pushbar}
\title{Setup Pushbar}
\usage{
pushbar_deps()

setup_pushbar(blur = FALSE, overlay = TRUE)

pushbar(..., id = from, from = c("left", "right", "top", "bottom"),
  class = NULL, style = pushbar_style())
}
\arguments{
\item{blur}{Whether to blur the background when pushbar is opened.}

\item{overlay}{Whether to darken the background when pushbar is opened.}

\item{...}{Any other valid \link[shiny]{tags}.}

\item{id}{Id of pushbar.}

\item{from}{Wherefrom the pushbar should open.}

\item{class}{Additional class to pass to \code{div}.}

\item{style}{Valid css defaults to \code{\link{pushbar_style}}.}
}
\description{
Set up pushbar.

Creates element containing pushbar content.
}
\details{
Creates a \code{div}.
}
\note{
You are advised to add \code{padding} inside your pushbar i.e.: \code{style="padding:20px;"}
}
\examples{
library(shiny)

ui <- fluidPage(
  pushbar_deps(),
  actionButton("open", "Open pushbar"),
  pushbar(
    h4("HELLO")
  )
)

server <- function(input, output, session){

  setup_pushbar()
 
  observeEvent(input$open, {
    pushbar_open()
  })  
}

if(interactive()) shinyApp(ui, server)

}
