% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FittedFW.R
\name{FittedFW}
\alias{FittedFW}
\title{Correct continuous fresh weight measurements}
\usage{
FittedFW(data, sample = "sample", fresh.weight = "fresh.weight",
  time.since.start = "time.since.start", graph = TRUE,
  show.legend = TRUE)
}
\arguments{
\item{data}{data frame, at least with a column containing numeric fresh weight (g) and time since start (min) values,
ordered by sample by descending fresh.weight.
A column containing the sample IDs is optionally required if several samples were measured.}

\item{sample}{optional name of the column in data containing the sample IDs, default: "sample"}

\item{fresh.weight}{optional name of the column in data containing the fresh weight values (g), default: "fresh weight"}

\item{time.since.start}{optional name of the column in data containing the time since start (min) values, default: "time.since.start"}

\item{graph}{set FALSE if no plots are to be returned}

\item{show.legend}{set FALSE if no legend is to be be shown in the plots}
}
\value{
the original data frame (data) extended by a numeric column containing the fitted fresh weight values ("fitted.fw")
}
\description{
Corrects fresh weight, measured continuously on a desiccating leaf for determination of minimum conductance, by fitting
the fresh weight values to a combined exponential and linear model
}
\details{
Determination of minimum conductance via a leaf drying curve requires fresh weight to be measured continuously on a
desiccating leaf. The fresh weight values are then used to calculate leaf conductance. If several leaves are measured on one scale, the
measurements are prone to noises, which influence conductance values largely. Here, the fresh weight data is corrected for noises by
fitting it to a combined linear and exponential model using the port algorithm of nls(). \cr
Before using this function, check the raw
data for an initial plateau. If the exponential decline does not onset directly, fitting might not succeed.
}
\examples{
# get example data
df <- TimeSinceStart(leaf_drying_data)
# remove plateauing data
df <- df[df$fw.plateau != "yes",]
# extend the data frame by saturated fresh weight
df <- FittedFW(df)

}
