% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gmin.R
\name{Gmin}
\alias{Gmin}
\title{Minimum leaf conductance}
\usage{
Gmin(data, sample = "sample", time.since.start = "time.since.start",
  conductance = "conductance", RWD = "RWD.interval",
  stom.clos.threshold = FALSE, graph = TRUE, show.legend = TRUE)
}
\arguments{
\item{data}{data frame containing columns of equal lengths giving the
coordinates of the curve: time since start (minutes), conductance (mmol m^-2 s^-1) and RWD (\%), ordered by sample by ascending time
since start. A column containing the sample IDs is optionally required if several samples were measured.}

\item{sample}{optional column name in data containing the sample ID, default: sample}

\item{time.since.start}{optional column name in data containing the numerical values for time since start of
the experiment (min), default: time.since.start}

\item{conductance}{optional column name in data containing the numerical conductance values (mmol m^-2 s^-1), default:
"conductance"}

\item{RWD}{optional column name in data containing the numerical relative water deficit values (\%), default: "RWD.interval" (RWD
average of an interval, as outputted by RWDInterval)}

\item{stom.clos.threshold}{threshold value for stomatal closure. Automatic determination by default.}

\item{graph}{set FALSE if no plots are to be returned}

\item{show.legend}{set FALSE if no legend is to be shown in the plots}
}
\value{
List splitted by sample consisting of
\item{gmin}{mean minimum conductance (mean.gmin) (mmol m^-2 s^-1) after stomatal closure of the measurement interval,
minimum conductance at full saturation (gmin.full.sat) (mmol m^-2 s^-1) and minimum conductance at stomatal closure based on the linear
fit (lin.gmin) (mmol m^-2 s^-1)}
\item{formula}{formula of the linear regression of gmin vs. RWD}
\item{coef}{coefficients of linear fit}
\item{conf_int}{upper (97.5 \%) and lower (2.5 \%) border of 95 \% confidence interval of model parameters}
If graph = TRUE, the plotted original data is displayed with the x-axis intercept of the point of
stomatal closure and the linear regression line of gmin showing the point of y-intercept (gminfullsat).
}
\description{
Determines mean minimum leaf conductance and minimum leaf conducance at full turgidity and stomatal closure in
experimentally obtained water loss curves.
}
\details{
The coordinates of stomatal closure are determined via the function StomatalClosure(). \cr
Conductance data including and following stomatal closure are then extracted and the average is taken (mean.gmin). A linear regression is
applied to the data and the y axis intercept (gmin.full.sat) and the coordinate at the RWD point of stomatal
closure (lin.gmin) are calculated from the function. \cr \cr
Before using this function, check the raw data for an initial plateau. If the exponential decline does not onset directly,
fitting might not succeed.
}
\examples{
# get example data
df <- WeatherAllocation(leaf_drying_data, weather_data)   # allocate weather to weight loss data
df <- TimeSinceStart(df) # calculate time since start
df <- df[df$fw.plateau != "yes",] # remove plateauing data
df <- FittedFW(df, graph = FALSE) # correct noises in fresh weight
df <- RWDInterval(df, fresh.weight = "fitted.fw") # calculate RWD based in the intervals
df <- Conductance(df, fresh.weight = "fitted.fw") # calculate conductance

# calculate gmin and plot graphs
gmin <- Gmin(df)

}
